/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;

namespace Borland.Eco.Diagnostics
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class EcoSpaceDebugger : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		private EcoSpace es;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.TabControl tabControl1;
		public EcoSpaceDebugger(EcoSpace es)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			this.es = es;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(EcoSpaceDebugger));
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("mainMenu1.RightToLeft")));
			// 
			// tabControl1
			// 
			this.tabControl1.AccessibleDescription = resources.GetString("tabControl1.AccessibleDescription");
			this.tabControl1.AccessibleName = resources.GetString("tabControl1.AccessibleName");
			this.tabControl1.Alignment = ((System.Windows.Forms.TabAlignment)(resources.GetObject("tabControl1.Alignment")));
			this.tabControl1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabControl1.Anchor")));
			this.tabControl1.Appearance = ((System.Windows.Forms.TabAppearance)(resources.GetObject("tabControl1.Appearance")));
			this.tabControl1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabControl1.BackgroundImage")));
			this.tabControl1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabControl1.Dock")));
			this.tabControl1.Enabled = ((bool)(resources.GetObject("tabControl1.Enabled")));
			this.tabControl1.Font = ((System.Drawing.Font)(resources.GetObject("tabControl1.Font")));
			this.tabControl1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabControl1.ImeMode")));
			this.tabControl1.ItemSize = ((System.Drawing.Size)(resources.GetObject("tabControl1.ItemSize")));
			this.tabControl1.Location = ((System.Drawing.Point)(resources.GetObject("tabControl1.Location")));
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.Padding = ((System.Drawing.Point)(resources.GetObject("tabControl1.Padding")));
			this.tabControl1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabControl1.RightToLeft")));
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.ShowToolTips = ((bool)(resources.GetObject("tabControl1.ShowToolTips")));
			this.tabControl1.Size = ((System.Drawing.Size)(resources.GetObject("tabControl1.Size")));
			this.tabControl1.TabIndex = ((int)(resources.GetObject("tabControl1.TabIndex")));
			this.tabControl1.Text = resources.GetString("tabControl1.Text");
			this.tabControl1.Visible = ((bool)(resources.GetObject("tabControl1.Visible")));
			// 
			// EcoSpaceDebugger
			// 
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.tabControl1);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "EcoSpaceDebugger";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.Load += new System.EventHandler(this.WinForm_Load);
			this.ResumeLayout(false);
		}
		#endregion

		private void AddPanel(IEcoSpaceDebuggerPanel p)
		{
			TabPage tp = new TabPage(p.Caption);
			p.Panel.Parent = tp;
			p.Panel.Width = tp.Width-5;
			p.Panel.Height = tp.Height-5;
			tabControl1.TabPages.Add(tp);
			p.Init(es);
		}

		private void WinForm_Load(object sender, System.EventArgs e)
		{
			AddPanel(new ClassAndOclDebuggerPanel());
			AddPanel(new DirtyObjectsDebuggerPanel());
			AddPanel(new UndoDebuggerPanel());
		}
	}

	public interface IEcoSpaceDebuggerPanel
	{
		Panel Panel { get; }
		string Caption { get; }
		MainMenu MainMenu { get; }
        void Init(EcoSpace es);
	}

	#region *** Custom ExceptionHandler ***
	/*
	this exception handler must be installed prior to Application.Run:

		[STAThreadAttribute]
		public static void Main()
		{
			WinFormDequeuer.Active = true;
			Borland.Eco.Diagnostics.ErrorHandler.InstallExceptionHandler();
			System.Windows.Forms.Application.Run(new MainForm());
		}
	*/

	public class ErrorHandler //: System.Windows.Forms.Form
	{
		private ErrorHandler() { }
		static private System.Threading.ThreadExceptionEventHandler exceptionHandler =
			new System.Threading.ThreadExceptionEventHandler(
				new CustomExceptionHandler().OnThreadException);
		public static void InstallExceptionHandler()
		{
			Application.ThreadException += exceptionHandler;
		}
		public static void UninstallExceptionHandler()
		{
			Application.ThreadException -= exceptionHandler;
		}
		private class CustomExceptionHandler 
		{
			// Handles the exception event.
			public void OnThreadException(object sender, System.Threading.ThreadExceptionEventArgs t)
			{
				DialogResult result = DialogResult.Cancel;
				try
				{
					result = ShowThreadExceptionDialog(t.Exception);
				}
				catch
				{
					try
					{
						MessageBox.Show(FormsStringRes.sFatalError, FormsStringRes.sFatalError, MessageBoxButtons.AbortRetryIgnore, MessageBoxIcon.Stop);
					}
					finally
					{
						Application.Exit();
					}
				}
				
				// Exits the program when the user clicks Abort.
				if (result == DialogResult.Abort)
					Application.Exit();
			}

			// Creates the error message and displays it.
			private static DialogResult ShowThreadExceptionDialog(Exception e) 
			{
				string errorMsg = "An error occurred please contact the administrator with the following information:\n\n"; // do not localize
				errorMsg = errorMsg + e.ToString(); // do not localize
				return MessageBox.Show(errorMsg, "Application Error", MessageBoxButtons.AbortRetryIgnore, MessageBoxIcon.Stop); // do not localize
			}
		}
	}
	#endregion

}
